<?php

namespace PWCSD\NemesiCMS\Admin\Hosting\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Domain extends Model 
{

    protected $table = 'domains';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function emailServer()
    {
        return $this->hasOne('Server', 'email_server_id');
    }

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

}